<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
require 'db_connect.php';

// Set the content type to application/json
header('Content-Type: application/json');

// Get the country from the request
$country = isset($_GET['country']) ? $_GET['country'] : '';

// Initialize query
$sql = "";
$params = array();
$types = "";

// Handling the "gulf" category
if (strtolower($country) === 'gulf') {
    $gulf_countries = array('Saudi Arabia', 'UAE', 'Kuwait', 'Qatar', 'Oman', 'Bahrain', 'Iran');
    $placeholders = implode(',', array_fill(0, count($gulf_countries), '?'));

    $sql = "SELECT * FROM jobs WHERE job_location IN ($placeholders) ORDER BY STR_TO_DATE(date, '%d/%m/%Y %H:%i:%s') DESC";
    $params = $gulf_countries;
    $types = str_repeat('s', count($gulf_countries));
} elseif (!empty($country)) {
    // If a specific country is provided, query by that country
    $sql = "SELECT * FROM jobs WHERE job_location = ? ORDER BY STR_TO_DATE(date, '%d/%m/%Y %H:%i:%s') DESC";
    $params = array($country);
    $types = "s";
} else {
    // If no valid criteria provided, return an error
    echo json_encode(["status" => "error", "message" => "No valid criteria provided"]);
    exit;
}

// Prepare and execute the query
$stmt = $conn->prepare($sql);
if ($types) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $jobs = array();
    while ($row = $result->fetch_assoc()) {
        // Convert numeric values to strings if needed
        foreach ($row as $key => $value) {
            $row[$key] = strval($value); // Ensure all values are strings
        }
        $jobs[] = $row;
    }

    // Query to get the total number of jobs based on the same criteria
    $total_jobs_query = $sql;
    $total_jobs_stmt = $conn->prepare($total_jobs_query);
    if ($types) {
        $total_jobs_stmt->bind_param($types, ...$params);
    }
    $total_jobs_stmt->execute();
    $total_jobs_result = $total_jobs_stmt->get_result();
    $total_jobs_count = $total_jobs_result->num_rows;

    // Construct final response
    $response = array(
        "status" => "success",
        "total_jobs" => strval($total_jobs_count), // Include total number of jobs
        "data" => $jobs
    );

    echo json_encode($response);
} else {
    echo json_encode(["status" => "error", "message" => "No jobs found"]);
}

// Close the connection
$conn->close();
?>
