<div class="saved-jobs-header">
    <h4 class="saved-jobs-title">
        <i class="fa fa-heart"></i>
        Saved Jobs
    </h4>
</div>

<div class="saved-table-card">
    <table class="saved-jobs-table">
        <thead>
            <tr>
                <th style="width:60px;">Id</th>
                <th class="text-start">Job</th>
                <th>Saved On</th>
                <th style="width:150px;">Action</th>
            </tr>
        </thead>

        <tbody>
            <?php if (!empty($savedJobs)): ?>
                <?php foreach ($savedJobs as $index => $job): ?>
                    <tr>
                        <td class="saved-row-number">
                            <?= $index + 1 ?>
                        </td>

                        <td>
                            <div class="job-info">
                                <span class="job-title">
                                    <?= htmlspecialchars($job['job_name']) ?>
                                </span>
                                <span class="job-location">
                                    <i class="fa fa-location-dot"></i>
                                    <?= htmlspecialchars($job['city_name'] ?? 'Location not specified') ?>
                                </span>
                            </div>
                        </td>

                        <td class="text-center">
                            <span class="saved-date-badge">
                                <?= date('d M Y', strtotime($job['created_at'])) ?>
                            </span>
                        </td>

                        <td>
                            <div class="saved-action-buttons">
                                <a href="<?= $baseURL ?>/view/frontend/job-details.php?id=<?= $job['job_id']; ?>"
                                    class="saved-btn-action saved-btn-view" title="View Job">
                                    <i class="fa fa-eye"></i>
                                </a>

                                <button class="saved-btn-action saved-btn-remove" onclick="unSaveJob(<?= $job['job_id'] ?>)"
                                    title="Remove">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>

            <?php else: ?>
                <tr>
                    <td colspan="4" class="saved-empty-state">
                        <i class="fa fa-heart-broken"></i>
                        <p>No saved jobs found</p>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>