<div class="account-settings-content">
    <h4 class="section-title mb-4">
        <i class="fa fa-user-circle me-2"></i>
        My Profile
    </h4>

    <form id="profileForm" class="needs-validation" novalidate>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="name"
                    value="<?= htmlspecialchars($_SESSION['user_name'] ?? '') ?>" required>
                <div class="invalid-feedback">Please enter your name.</div>
            </div>

            <div class="col-md-6 mb-3">
                <label class="form-label">Email <span class="text-danger">*</span></label>
                <input type="email" class="form-control" name="email"
                    value="<?= htmlspecialchars($_SESSION['email'] ?? '') ?>" required>
                <div class="invalid-feedback">Please enter a valid email.</div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">Phone <span class="text-danger">*</span></label>
                <input type="tel" class="form-control" name="phone"
                    value="<?= htmlspecialchars($_SESSION['user_phone'] ?? '') ?>" required>
                <div class="invalid-feedback">Please enter your phone number.</div>
            </div>
        </div>

        <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save me-1"></i> Update Profile
            </button>
            <button type="reset" class="btn btn-outline-secondary">
                <i class="fa fa-undo me-1"></i> Reset
            </button>
        </div>
    </form>

    <hr class="my-5">

    <!-- Change Password Section -->
    <div class="password-section">
        <h4 class="section-title mb-4">
            <i class="fa fa-lock me-2"></i>
            Change Password
        </h4>

        <form id="passwordForm" class="needs-validation" novalidate>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Old Password <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <input type="password" class="form-control" name="old_password" placeholder="Enter old password"
                            required>
                        <button class="btn btn-outline-secondary toggle-password" type="button">
                            <i class="fa fa-eye"></i>
                        </button>
                    </div>
                    <div class="invalid-feedback">Please enter your old password.</div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">New Password <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <input type="password" class="form-control" name="new_password" placeholder="Enter new password"
                            required>
                        <button class="btn btn-outline-secondary toggle-password" type="button">
                            <i class="fa fa-eye"></i>
                        </button>
                    </div>
                    <div class="invalid-feedback">Please enter a new password.</div>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="form-label">Confirm Password <span class="text-danger">*</span></label>
                    <div class="input-group">
                        <input type="password" class="form-control" name="confirm_password"
                            placeholder="Confirm new password" required>
                        <button class="btn btn-outline-secondary toggle-password" type="button">
                            <i class="fa fa-eye"></i>
                        </button>
                    </div>
                    <div class="invalid-feedback">Please confirm your password.</div>
                </div>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fa fa-check me-1"></i> Update Password
            </button>
        </form>
    </div>
</div>