<?php
$pageTitle = "Home | Career Nest";
include_once __DIR__ . '/../../components/frontend/header.php';
?>

<?php
include_once __DIR__ . '/../../config/dbcon.php';

$sql = "
    SELECT * FROM pages where type = 'privacy_policy' AND deleted_at IS NULL
";

$stmt = $conn->prepare($sql);
$stmt->execute();
$pages = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>
<style>
    .page-title {
        display: inline-block;
        padding: 14px 32px;
        background-color: blueviolet;
        color: var(--text-light);
        border-radius: var(--radius-full);
        box-shadow: var(--shadow-md);
        font-family: var(--font-main);
        transition: var(--transition-base);
    }

    /* Center align block */
    .page-title {
        margin-left: auto;
        margin-right: auto;
    }

    /* Optional hover effect */
    .page-title:hover {
        transform: translateY(-2px);
        box-shadow: var(--shadow-hover);
    }
</style>

<section class="section-3 py-5" style="background:#f5f7fa;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-10">
                <?php if (!empty($pages)):
                    $page = $pages[0]; // single page
                    ?>
                    <div class="card shadow-sm border-0 rounded-4">
                        <div class="card-body p-4 p-md-5">
                            <!-- Page Title -->
                            <h2 class="text-center mb-4 fw-bold">
                                <?= strtoupper(str_replace('_', ' ', $page['type'])) ?>
                            </h2>

                            <!-- Divider -->
                            <hr class="mb-4">

                            <!-- Page Description -->
                            <div class="text-muted privacy-content" style="line-height: 1.8;">
                                <?= $page['description']; ?>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning text-center">
                        Privacy policy not found.
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>


<?php
include_once __DIR__ . '/../../components/frontend/footer.php';
?>