<?php
include_once __DIR__ . "/../../../config/check-login.php";
include_once __DIR__ . "/../../../config/dbcon.php";

/* Fetch logged-in user ONCE */
$user = null;

if (!empty($_SESSION['user_uid'])) {
  $stmt = $conn->prepare("
        SELECT name, email, phone, profile
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
  $stmt->execute([':uid' => $_SESSION['user_uid']]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>

<?php
$pageTitle = "Admin Request";
$pageHeading = "Admin Request";
?>
<?php include __DIR__ . '/../../../components/backend/sidebar.php'; ?>
<?php include __DIR__ . '/../../../components/backend/header.php'; ?>
<?php include __DIR__ . '/../../../config/dbcon.php'; ?>

<?php
$query = "SELECT * FROM users 
          WHERE role = 'subadmin' 
          AND status = 'pending' 
          AND deleted_at IS NULL 
          ORDER BY created_at DESC";
$stmt = $conn->prepare($query);
$stmt->execute();
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

$permissions = [
  "manage_user" => "Manage User",
  "manage_category" => "Manage Category",
  "manage_country" => "Manage Country",
  "manage_state" => "Manage State",
  "manage_city" => "Manage City",
  "manage_policies" => "Manage Policies"
];
?>

<div class="main-wrapper">
  <div class="page-header">
    <h2 class="page-title">Manage Admin Requests</h2>
  </div>

  <div class="modern-table-card mt-3">
    <div class="table-responsive-wrapper">
      <table class="modern-table">
        <thead>
          <tr>
            <th>ID</th>
            <th>Profile</th>
            <th>Name</th>
            <th>Email</th>
            <th>Phone</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($users): ?>
            <?php foreach ($users as $index => $user): ?>
              <tr>
                <td><?= $index + 1 ?></td>
                <td>
                  <img src="<?= (!empty($user['profile']) && file_exists(__DIR__ . '/../../../uploads/profile/' . $user['profile']))
                    ? '../../../uploads/profile/' . htmlspecialchars($user['profile'])
                    : '../../../assets/img/default-avatar-icon.png' ?>" width="40" height="40" class="rounded-circle">
                </td>
                <td><?= htmlspecialchars($user['name']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= htmlspecialchars($user['phone']) ?></td>
                <td>
                  <!-- ONLY MODAL OPENER -->
                  <button type="button" class="btn btn-outline-primary manage-user-btn" data-bs-toggle="modal"
                    data-bs-target="#manageUserModel" data-user-id="<?= (int) $user['id'] ?>" title="Manage Admin">
                    <i class="fas fa-user-cog"></i>
                  </button>
                </td>
              </tr>
            <?php endforeach; ?>
          <?php else: ?>
            <tr>
              <td colspan="6" class="text-center">No Requests found</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- MODAL -->
<div class="modal fade" id="manageUserModel" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Manage Admin Request</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <form id="manageUserForm" novalidate>

          <!-- HIDDEN USER ID -->
          <input type="hidden" id="manage_user_id">

          <!-- STATUS -->
          <div class="mb-3">
            <label class="form-label">Status</label>
            <select id="user_status" class="form-select">
              <option value="">Select Status</option>
              <option value="accept">Accept</option>
              <option value="reject">Reject</option>
            </select>
            <div class="invalid-feedback" id="user-status-error"></div>
          </div>

          <!-- PERMISSIONS -->
          <div class="mb-3" id="permission_selector">
            <label class="form-label">Permissions</label>
            <select id="user_permissions" class="select2" multiple style="width:100%">
              <?php foreach ($permissions as $key => $label): ?>
                <option value="<?= $key ?>"><?= $label ?></option>
              <?php endforeach; ?>
            </select>
            <div class="invalid-feedback" id="user-permission-error"></div>
          </div>

          <div class="d-flex gap-2">
            <button type="submit" class="btn btn-primary w-50">Ok</button>
            <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">
              Cancel
            </button>
          </div>

        </form>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../../components/backend/footer.php'; ?>