<?php
include_once __DIR__ . "/../../../config/check-login.php";
include_once __DIR__ . "/../../../config/dbcon.php";

/* Fetch logged-in user ONCE */
$user = null;

if (!empty($_SESSION['user_uid'])) {
    $stmt = $conn->prepare("
        SELECT name, email, phone, profile
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
    $stmt->execute([':uid' => $_SESSION['user_uid']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>
<?php
$pageTitle = "Page";
$pageHeading = "Page";
?>

<?php include __DIR__ . '/../../../components/backend/sidebar.php'; ?>
<?php include __DIR__ . '/../../../components/backend/header.php'; ?>
<?php include __DIR__ . '/../../../config/dbcon.php';

$query = "SELECT * FROM pages WHERE deleted_at IS NULL ORDER BY id DESC";
$stmt = $conn->prepare($query);
$stmt->execute();
$pages = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<div class="custom-toast-container" id="toastContainer"></div>

<div class="main-wrapper">
    <div class="page-header">
        <h2 class="page-title">Page List</h2>
        <a href="#" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPageModal">
            Add Page
        </a>
    </div>
    <div class="policy-card-wrapper mt-4">
        <?php if (!empty($pages)): ?>
            <?php foreach ($pages as $page): ?>
                <div class="policy-card">
                    <div class="policy-card-body">

                        <!-- Policy Title -->
                        <h5 class="policy-title">
                            <?= ucwords(str_replace('_', ' ', $page['type'])) ?>
                        </h5>

                        <!-- Policy Description -->
                        <p class="policy-description">
                            <?= $page['description'] ?>
                        </p>
                    </div>

                    <!-- Actions -->
                    <div class="policy-card-actions">
                        <button class="btn btn-sm btn-outline-primary" onclick="EditPolicy(
                            <?= $page['id'] ?>,
                            '<?= $page['type'] ?>',
                            `<?= addslashes($page['description']) ?>`
                        )" title="Edit Policy">
                            <i class="fas fa-edit"></i>
                        </button>

                        <button class="btn btn-sm btn-outline-danger" onclick="DeletePolicy(<?= $page['id'] ?>)"
                            title="Delete Policy">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p class="text-center text-muted">No policies found</p>
        <?php endif; ?>
    </div>


    <!-- Add Page Modal -->
    <div class="modal fade" id="addPageModal" tabindex="-1" aria-labelledby="addPageModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title" id="addPageModalLabel">Add Policy</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="addPageForm" novalidate>

                        <!-- POLICY TYPE -->
                        <div class="mb-3 position-relative">
                            <label class="form-label">Policy Type</label>

                            <select class="form-select" name="policy_type" id="policyType" required>
                                <option value="" disabled selected>Select Policy Type</option>
                                <option value="privacy_policy">Privacy Policy</option>
                                <option value="terms_conditions">Terms & Conditions</option>
                                <option value="cookie_policy">Cookie Policy</option>
                                <option value="refund_policy">Refund & Cancellation Policy</option>
                                <option value="disclaimer">Disclaimer</option>
                                <option value="equal_opportunity">Equal Opportunity Policy</option>
                                <option value="security_policy">Security Policy</option>
                            </select>

                            <div class="invalid-feedback" id="policy-type-error"></div>
                        </div>


                        <!-- POLICY DESCRIPTION -->
                        <div class="mb-3 position-relative">
                            <label class="form-label">Description</label>

                            <textarea class="form-control" name="description" id="policyDescription" rows="5"
                                placeholder="Enter policy description"></textarea>

                            <div class="invalid-feedback d-block" id="policy-description-error"></div>
                        </div>


                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary w-50">Add Policy</button>
                            <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <!-- Edit Policy Modal -->
    <div class="modal fade" id="editPageModal" tabindex="-1" aria-labelledby="editPageModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title" id="editPageModalLabel">Edit Policy</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <form id="editPageForm" novalidate>

                        <!-- POLICY ID -->
                        <input type="hidden" name="id" id="edit_policy_id">

                        <!-- POLICY TYPE -->
                        <div class="mb-3">
                            <label class="form-label">Policy Type</label>
                            <select class="form-select" name="policy_type" id="editPolicyType" required>
                                <option value="">Select Policy Type</option>
                                <option value="privacy_policy">Privacy Policy</option>
                                <option value="terms_conditions">Terms & Conditions</option>
                                <option value="cookie_policy">Cookie Policy</option>
                                <option value="refund_policy">Refund & Cancellation Policy</option>
                                <option value="disclaimer">Disclaimer</option>
                                <option value="equal_opportunity">Equal Opportunity Policy</option>
                                <option value="security_policy">Security Policy</option>
                            </select>
                            <div class="invalid-feedback" id="edit-policy-type-error"></div>
                        </div>

                        <!-- POLICY DESCRIPTION -->
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" id="editPolicyDescription" rows="5"
                                required></textarea>
                            <div class="invalid-feedback" id="edit-policy-description-error"></div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary w-50">Update Policy</button>
                            <button type="button" class="btn btn-secondary w-50" data-bs-dismiss="modal">Cancel</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>


    <?php include __DIR__ . '/../../../components/backend/footer.php'; ?>