<?php 
$page_title="Register";
ob_start(); 
?>
<div class="row">

    <!-- LEFT IMAGE -->
    <div class="col-12 col-lg-6 p-0">
        <div class="form-img h-100">
            <img src="assets/img/registration.jpg" class="w-100 h-100 object-fit-cover" />
        </div>
    </div>

    <!-- RIGHT CONTENT -->
    <div class="col-12 col-lg-6 d-flex align-items-center">

        <div class="form-con p-4 w-100">

            <h2 class="title mb-4">Sign Up</h2>

            <form class="needs-validation" id="register-form" novalidate>

                <!-- NAME -->
                <div class="mb-3">
                    <label class="form-label">Full Name</label>
                    <input 
                        type="text" 
                        class="form-control" 
                        id="reg-name" 
                        placeholder="Enter full name" 
                        required
                    >
                    <div class="invalid-feedback" id="reg-name-error"></div>
                </div>

                <!-- EMAIL -->
                <div class="mb-3">
                    <label class="form-label">Email address</label>
                    <input 
                        type="email" 
                        class="form-control" 
                        id="reg-email" 
                        placeholder="Enter email" 
                        required
                    >
                    <div class="invalid-feedback" id="reg-email-error"></div>
                </div>

                <!-- PASSWORD -->
                <div class="mb-4">
                    <label class="form-label">Password</label>
                    <input 
                        type="password" 
                        class="form-control" 
                        id="reg-password" 
                        placeholder="Enter password" 
                        required
                    >
                    <div class="invalid-feedback" id="reg-password-error"></div>
                </div>

                <button type="submit" id="register-btn" class="btn btn-primary w-100 mb-2">Sign Up</button>
            </form>

            <p class="mt-3 text-center">
                Already have an account?
                <a href="login.php" class="text-primary fw-semibold">Sign In</a>
            </p>

        </div>
    </div>

</div>
<?php 
$content = ob_get_clean();
include 'common/center-card.php';
?>
