<?php
$pageTitle = "Home | Career Nest";
include_once __DIR__ . '/components/frontend/header.php';
?>

<?php
include_once __DIR__ . '/config/dbcon.php';

$stmt = $conn->prepare("
    SELECT 
        c.id,
        c.category_name,
        COUNT(j.id) AS job_count
    FROM categories c
    LEFT JOIN jobs j 
        ON j.category_id = c.id 
        AND j.deleted_at IS NULL
    WHERE c.deleted_at IS NULL
    GROUP BY c.id
    ORDER BY c.category_name ASC
");

$stmt->execute();
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $conn->prepare("
    SELECT
        id,
        job_name,
        job_type,
        job_description,
        job_salary,
        job_available_positions
    FROM jobs
    WHERE 
        is_featured = 1
        AND deleted_at IS NULL
        AND (expiry_date IS NULL OR expiry_date >= CURDATE())
    ORDER BY created_at DESC
    LIMIT 6
");

$stmt->execute();
$featuredJobs = $stmt->fetchAll(PDO::FETCH_ASSOC);

$stmt = $conn->prepare("
    SELECT
        id,
        job_name,
        job_type,
        job_description,
        job_salary,
        job_available_positions
    FROM jobs
    WHERE deleted_at IS NULL
    ORDER BY created_at DESC
    LIMIT 9
");

$stmt->execute();
$latestJobs = $stmt->fetchAll(PDO::FETCH_ASSOC);

?>

<!-- Search Section -->
<section id="search-section" class="search-hero">
    <div class="search-gradient-overlay"></div>
    <div class="container position-relative">
        <!-- Header -->
        <div class="text-center search-header">
            <div class="search-icon-badge">
                <i class="fa fa-search"></i>
            </div>
            <h2 class="search-title">Find Your Dream Job</h2>
            <p class="search-subtitle">Discover opportunities that match your skills and aspirations</p>
        </div>

        <!-- Search Box -->
        <div class="search-card">
            <form action="view/frontend/job.php" method="GET">
                <div class="search-grid">
                    <!-- Keywords Input -->
                    <div class="search-input-wrapper">
                        <div class="search-input-icon">
                            <i class="fa fa-search"></i>
                        </div>
                        <input 
                            type="text" 
                            class="search-input" 
                            name="keywords" 
                            placeholder="Job title, skills, or company"
                            value="<?php echo isset($_GET['keywords']) ? htmlspecialchars($_GET['keywords']) : ''; ?>">
                    </div>

                    <!-- Location Input -->
                    <div class="search-input-wrapper">
                        <div class="search-input-icon">
                            <i class="fa fa-map-marker"></i>
                        </div>
                        <input 
                            type="text" 
                            class="search-input" 
                            name="location" 
                            placeholder="City, state, or remote"
                            value="<?php echo isset($_GET['location']) ? htmlspecialchars($_GET['location']) : ''; ?>">
                    </div>

                    <!-- Category Select -->
                    <div class="search-input-wrapper">
                        <div class="search-input-icon">
                            <i class="fa fa-briefcase"></i>
                        </div>
                        <select name="category" class="search-select">
                            <option value="">All Categories</option>
                            <?php if (!empty($categories)): ?>
                                <?php foreach ($categories as $category): ?>
                                    <option value="<?= $category['id']; ?>" 
                                        <?= (isset($_GET['category']) && $_GET['category'] == $category['id']) ? 'selected' : ''; ?>>
                                        <?= htmlspecialchars($category['category_name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <option value="">No categories available</option>
                            <?php endif; ?>
                        </select>
                        <div class="search-select-arrow">
                            <i class="fa fa-chevron-down"></i>
                        </div>
                    </div>

                    <!-- Search Button -->
                    <div class="search-btn-wrapper">
                        <button type="submit" class="search-btn">
                            <span class="search-btn-text">Search Jobs</span>
                            <i class="fa fa-arrow-right search-btn-icon"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Quick Stats or Tags (Optional) -->
        <div class="search-quick-info">
            <div class="quick-stat">
                <i class="fa fa-briefcase"></i>
                <span>1000+ Active Jobs</span>
            </div>
            <div class="quick-stat">
                <i class="fa fa-building"></i>
                <span>500+ Companies</span>
            </div>
            <div class="quick-stat">
                <i class="fa fa-users"></i>
                <span>10K+ Job Seekers</span>
            </div>
        </div>
    </div>
</section>

<!-- Popular Categories -->
<section class="py-5 category-section" id="popular-categories">
    <div class="container position-relative">

        <!-- Section Title -->
        <div class="text-center category-header mt-5">
            <h2 class="category-main-title">
                🌟 Explore Popular Categories
            </h2>
            <p class="category-subtitle">
                Find jobs that suit your passion and career goals
            </p>
        </div>

        <?php
        $categoryIcons = [
            1 => 'fa-robot',
            2 => 'fa-database',
            3 => 'fa-shield-alt',
            4 => 'fa-cloud',
            5 => 'fa-stethoscope',
            6 => 'fa-bullhorn',
            7 => 'fa-hard-hat',
            8 => 'fa-university'
        ];

        $categoryColors = [
            1 => '#6f42c1',
            2 => '#0d6efd',
            3 => '#dc3545',
            4 => '#0dcaf0',
            5 => '#198754',
            6 => '#fd7e14',
            7 => '#ffc107',
            8 => '#20c997'
        ];
        ?>

        <!-- Category Cards -->
        <div class="row g-4">

            <?php foreach ($categories as $category): ?>
                <?php
                $icon = $categoryIcons[$category['id']] ?? 'fa-briefcase';
                $color = $categoryColors[$category['id']] ?? '#0d6efd';
                ?>
                <div class="col-lg-3 col-md-6 col-sm-12">
                    <a href="<?= $baseURL ?>/view/frontend/job.php?category=<?= $category['id']; ?>"
                        class="text-decoration-none">

                        <div class="category-card" 
                             data-color="<?= $color; ?>"
                             style="--card-color: <?= $color; ?>">

                            <div class="icon-wrapper">
                                <i class="fa <?= $icon; ?>"></i>
                            </div>

                            <h5 class="category-title">
                                <?= htmlspecialchars($category['category_name']); ?>
                            </h5>

                            <div class="category-job-count">
                                <span><?= (int) $category['job_count']; ?> Jobs</span>
                            </div>

                        </div>
                    </a>
                </div>
            <?php endforeach; ?>

        </div>
    </div>
</section>

<!-- Featured Jobs -->
<section class="py-5 featured-jobs-section" id="featured-jobs">
    <div class="container position-relative" style="z-index: 1;">
        <div class="text-center mt-5">
            <h2 class="featured-section-title text-white">
                <i class="fa fa-fire text-warning me-2"></i> <span style="color: #ffc107;">Featured Jobs</span>
            </h2>
        </div>
        
        <div class="row g-4">

            <?php if (!empty($featuredJobs)): ?>
                <?php foreach ($featuredJobs as $featured): ?>

                    <?php
                    // Truncate description to 12 words
                    $words = explode(' ', strip_tags($featured['job_description']));
                    $truncated = implode(' ', array_slice($words, 0, 12));
                    if (count($words) > 12) {
                        $truncated .= '...';
                    }
                    ?>

                    <div class="col-md-4">
                        <div class="featured-job-card">

                            <!-- Featured Ribbon -->
                            <div class="featured-ribbon">
                                Featured
                            </div>

                            <div class="featured-card-body">
                                <h5 class="featured-job-title">
                                    <?= htmlspecialchars($featured['job_name']); ?>
                                </h5>

                                <p class="featured-job-description">
                                    <?= htmlspecialchars($truncated); ?>
                                </p>

                                <!-- Job Meta -->
                                <div class="featured-job-meta">
                                    <div class="featured-meta-item">
                                        <i class="fa fa-briefcase featured-icon-briefcase"></i>
                                        <span><?= ucfirst(str_replace('_', ' ', $featured['job_type'])); ?></span>
                                    </div>

                                    <div class="featured-meta-item">
                                        <i class="fa fa-users featured-icon-users"></i>
                                        <span><?= (int) $featured['job_available_positions']; ?> Vacancy</span>
                                    </div>

                                    <div class="featured-meta-item">
                                        <i class="fa fa-rupee featured-icon-salary"></i>
                                        <span><?= htmlspecialchars($featured['job_salary']); ?></span>
                                    </div>
                                </div>

                                <!-- Action Button -->
                                <a href="<?= $baseURL ?>/view/frontend/job-details.php?id=<?= $featured['id']; ?>"
                                    class="btn-featured-details w-100">
                                    <span>View Full Details <i class="fa fa-arrow-right ms-2"></i></span>
                                </a>
                            </div>

                        </div>
                    </div>

                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="featured-no-jobs-alert">
                        <i class="fa fa-star fa-3x mb-3"></i>
                        <p class="mb-0">No featured jobs available right now. Check back soon for exciting opportunities!</p>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </div>
</section>

<!-- Latest Jobs -->
<section class="py-5 latest-jobs-section" id="latest-jobs">
    <div class="container">
        <div class="text-center mt-5">
            <h2 class="section-title text-dark">
                <i class="fa fa-rocket text-success me-2"></i> Latest <span class="text-success">Jobs</span>
            </h2>
        </div>
        
        <div class="row g-4">
            <?php if (!empty($latestJobs)): ?>
                <?php foreach ($latestJobs as $latest): ?>

                    <?php
                    // Truncate description to 15 words
                    $words = explode(' ', strip_tags($latest['job_description']));
                    $truncated = implode(' ', array_slice($words, 0, 15));
                    if (count($words) > 15) {
                        $truncated .= '...';
                    }
                    ?>

                    <div class="col-md-4">
                        <div class="modern-job-card">

                            <!-- Job Header -->
                            <div>
                                <h5 class="job-title">
                                    <?= htmlspecialchars($latest['job_name']); ?>
                                </h5>
                                <p class="job-description">
                                    <?= htmlspecialchars($truncated); ?>
                                </p>
                            </div>

                            <!-- Job Meta -->
                            <div class="job-meta">
                                <p class="job-meta-item">
                                    <i class="fa fa-briefcase meta-icon-briefcase"></i>
                                    <span><?= ucfirst(str_replace('_', ' ', $latest['job_type'])); ?></span>
                                </p>
                                <p class="job-meta-item">
                                    <i class="fa fa-users meta-icon-users"></i>
                                    <span><?= (int) $latest['job_available_positions']; ?> Vacancy</span>
                                </p>
                                <p class="job-meta-item">
                                    <i class="fa fa-rupee meta-icon-salary"></i>
                                    <span><?= htmlspecialchars($latest['job_salary']); ?></span>
                                </p>
                            </div>

                            <!-- Action Button -->
                            <div class="mt-auto">
                                <a href="<?= $baseURL ?>/view/frontend/job-details.php?id=<?= $latest['id']; ?>"
                                    class="btn-view-details w-100">
                                    View Details <i class="fa fa-arrow-right ms-2"></i>
                                </a>
                            </div>

                        </div>
                    </div>

                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="no-jobs-alert">
                        <i class="fa fa-info-circle fa-2x mb-3"></i>
                        <p class="mb-0 fs-5">No jobs available at the moment. Check back soon!</p>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </div>
</section>

<!-- Contact Section -->
<section id="contact" class="contact-section py-5">
    <div class="container">

        <!-- Section Title -->
        <div class="text-center mt-5">
            <h2 class="fw-bold">
                <i class="fa fa-paper-plane text-primary me-2"></i>
                Let’s <span class="text-secondary">Connect</span>
            </h2>
            <p class="text-muted">
                Have a question or idea? Reach out and we’ll respond quickly.
            </p>
        </div>

        <div class="row g-4">

            <!-- Contact Info -->
            <div class="col-lg-4">
                <div class="contact-info-card h-100">

                    <h5 class="fw-bold mb-4 text-primary">
                        Get in Touch
                    </h5>

                    <div class="contact-info-item">
                        <div class="icon bg-primary">
                            <i class="fa fa-map-marker-alt"></i>
                        </div>
                        <p>
                            "Shree Kankai Krupa" Rokadiya Hanuman Road,
                            Prashant Pan Gali, OPP. Charan Aie Mandir,
                            Khapat, Porbandar, India
                        </p>
                    </div>

                    <div class="contact-info-item">
                        <div class="icon bg-secondary">
                            <i class="fa fa-envelope"></i>
                        </div>
                        <p>bamaniamohit2@gmail.com</p>
                    </div>

                    <div class="contact-info-item">
                        <div class="icon bg-accent">
                            <i class="fa fa-phone"></i>
                        </div>
                        <p>+91 94084 88791</p>
                    </div>

                </div>
            </div>

            <!-- Contact Form -->
            <div class="col-lg-8">
                <div class="contact-form-card h-100">

                    <h5 class="fw-bold mb-4 text-primary">
                        Send Us a Message
                    </h5>

                    <!-- Alerts (unchanged PHP logic) -->
                    <?php if (isset($_SESSION['contact_success'])): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <i class="fa fa-check-circle me-2"></i>
                            <?= htmlspecialchars($_SESSION['contact_success']) ?>
                            <button class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['contact_success']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['contact_error'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="fa fa-exclamation-circle me-2"></i>
                            <?= htmlspecialchars($_SESSION['contact_error']) ?>
                            <button class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['contact_error']); ?>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="row g-3">

                            <div class="col-md-6">
                                <label class="form-label">Your Name</label>
                                <input type="text" name="name" class="form-control form-control-theme"
                                    value="<?= $_SESSION['contact_form']['name'] ?? '' ?>" required>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">Your Email</label>
                                <input type="email" name="email" class="form-control form-control-theme"
                                    value="<?= $_SESSION['contact_form']['email'] ?? '' ?>" required>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">Subject</label>
                                <input type="text" name="subject" class="form-control form-control-theme"
                                    value="<?= $_SESSION['contact_form']['subject'] ?? '' ?>" required>
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">Your Message</label>
                                <textarea name="message" rows="5"
                                    class="form-control form-control-theme"
                                    required><?= $_SESSION['contact_form']['message'] ?? '' ?></textarea>
                            </div>

                            <div class="col-12 text-end">
                                <button type="submit" class="btn btn-theme-primary px-4 py-2">
                                    <i class="fa fa-paper-plane me-2"></i> Send Message
                                </button>
                            </div>

                        </div>
                    </form>

                    <?php unset($_SESSION['contact_form']); ?>
                </div>
            </div>

        </div>
    </div>
</section>


<?php
include_once __DIR__ . '/components/frontend/footer.php';
?>