<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$isLoggedIn = isset($_SESSION['user_id']);
$role = $_SESSION['role'] ?? null;
$currentPage = basename($_SERVER['PHP_SELF']);

$baseURL = "http://localhost/carrier_job_admin";
$pageTitle = $pageTitle ?? 'Career Nest';
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?= htmlspecialchars($pageTitle) ?></title>

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?= $baseURL ?>/assets/bootstrap/css/bootstrap.min.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <!-- Summernote CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?= $baseURL ?>/assets/frontend/css/app.css">
</head>

<body>

    <!-- ================= HEADER / NAVBAR ================= -->
    <header>
        <nav class="navbar navbar-expand-lg custom-navbar fixed-top">
            <div class="container-fluid">

                <a href="<?= $baseURL ?>/index.php" class="navbar-brand d-flex align-items-center fw-bold fs-4">
                    <i class="bi bi-lightning-charge-fill me-2 text-gradient fs-2"></i>
                    <span>Career<span class="text-success">Nest</span></span>
                </a>

                <button class="navbar-toggler border-0 shadow-sm" type="button" data-bs-toggle="collapse"
                    data-bs-target="#uniqueNavbar">
                    <i class="bi bi-list fs-2 text-primary"></i>
                </button>

                <div class="collapse navbar-collapse" id="uniqueNavbar">
                    <ul class="navbar-nav mx-auto mb-2 mb-lg-0 align-items-lg-center">

                        <li class="nav-item mx-2">
                            <a class="nav-link fw-semibold <?= $currentPage === 'index.php' ? 'active' : '' ?>"
                                href="<?= $baseURL ?>/index.php">Home</a>
                        </li>

                        <li class="nav-item mx-2">
                            <a class="nav-link fw-semibold <?= $currentPage === 'job.php' ? 'active' : '' ?>"
                                href="<?= $baseURL ?>/view/frontend/job.php">Find Jobs</a>
                        </li>

                        <li class="nav-item mx-2">
                            <a class="nav-link fw-semibold" href="<?= $baseURL ?>/index.php#popular-categories">Popular
                                Category</a>
                        </li>

                        <li class="nav-item mx-2">
                            <a class="nav-link fw-semibold" href="<?= $baseURL ?>/index.php#featured-jobs">Featured
                                Job</a>
                        </li>


                        <li class="nav-item mx-2">
                            <a class="nav-link fw-semibold" href="<?= $baseURL ?>/index.php#latest-jobs">Latest Job</a>
                        </li>

                        <li class="nav-item mx-2">
                            <a class="nav-link fw-semibold" href="<?= $baseURL ?>/index.php#contact">Contact</a>
                        </li>
                    </ul>


                    <div class="d-flex align-items-center ms-lg-4 gap-2">
                        <?php if (!$isLoggedIn): ?>
                            <!-- Show Login & Register if not logged in -->
                            <a class="btn btn-login rounded-pill px-4" href="#" data-bs-toggle="modal"
                                data-bs-target="#loginModal">
                                Login
                            </a>

                            <a class="btn btn-outline-success rounded-pill px-4" href="#" data-bs-toggle="modal"
                                data-bs-target="#registerModal">
                                Register
                            </a>
                        <?php else: ?>
                            <!-- Show Account & Post Job if logged in -->
                            <a class="btn btn-role rounded-pill px-4"
                                href="<?= $baseURL ?>/view/frontend/user-profile.php">Account</a>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Login Modal -->
        <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content p-4 rounded-4">
                    <div class="modal-header border-0">
                        <h5 class="modal-title" id="loginModalLabel">Login to Your Account</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="#" id="loginForm" method="POST">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email address</label>
                                <input type="email" class="form-control rounded-pill" id="email" name="email"
                                    placeholder="Enter email" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control rounded-pill" id="password" name="password"
                                    placeholder="Enter password" required>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="rememberMe">
                                    <label class="form-check-label" for="rememberMe">
                                        Remember me
                                    </label>
                                </div>
                                <a href="#" class="small text-decoration-none">Forgot password?</a>
                            </div>
                            <button type="submit" class="btn btn-primary w-100 rounded-pill">Login</button>
                        </form>
                        <div class="text-center mt-3">
                            <span>Don't have an account? </span>
                            <a href="#" data-bs-toggle="modal" data-bs-target="#registerModal"
                                class="text-decoration-none">Register</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Registration Modal -->
        <div class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content p-4 rounded-4">
                    <div class="modal-header border-0">
                        <h5 class="modal-title" id="registerModalLabel">Create an Account</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form action="#" id="registerForm" method="POST">
                            <!-- Name -->
                            <div class="mb-3">
                                <label for="name" class="form-label">Full Name</label>
                                <input type="text" class="form-control rounded-pill" id="name" name="name"
                                    placeholder="Enter your full name" required>
                            </div>

                            <!-- Email -->
                            <div class="mb-3">
                                <label for="reg-email" class="form-label">Email Address</label>
                                <input type="email" class="form-control rounded-pill" id="reg-email" name="email"
                                    placeholder="Enter your email" required>
                            </div>

                            <!-- Password -->
                            <div class="mb-3">
                                <label for="reg-password" class="form-label">Password</label>
                                <input type="password" class="form-control rounded-pill" id="reg-password"
                                    name="password" placeholder="Enter password" required>
                            </div>

                            <!-- Phone Number -->
                            <div class="mb-3">
                                <label for="phone" class="form-label">Phone Number</label>
                                <input type="tel" class="form-control rounded-pill" id="phone" name="phone"
                                    placeholder="Enter phone number" required>
                            </div>

                            <!-- User Type Dropdown -->
                            <div class="mb-3">
                                <label for="user_type" class="form-label">Register As</label>
                                <select class="form-select rounded-pill" id="user_type" name="user_type" required>
                                    <option value="">Select account type</option>
                                    <option value="user">User</option>
                                    <option value="employee">Employee</option>
                                </select>
                            </div>

                            <!-- Submit Button -->
                            <button type="submit" class="btn btn-success w-100 rounded-pill">Register</button>
                        </form>
                        <div class="text-center mt-3">
                            <span>Already have an account? </span>
                            <a href="#" data-bs-toggle="modal" data-bs-target="#loginModal"
                                data-bs-dismiss="modal">Login</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Bootstrap Toast Container -->
    <div class="toast-container">
        <div id="appToast" class="toast align-items-center border-0" role="alert" aria-live="assertive"
            aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">
                    Message here
                </div>
                <button type="button" class="btn-close me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>
    </div>

    <!-- Confirm Apply Modal -->
    <div class="modal fade" id="confirmApplyModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-4">
                <h5 class="modal-title">Confirm Job Application</h5>
                <p>Are you sure you want to apply for this job?</p>
                <div class="d-flex justify-content-end gap-2">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button id="confirmApplyBtn" class="btn btn-primary">Apply</button>
                </div>
            </div>
        </div>
    </div>


    <script>
        window.BASE_URL = "<?= $baseURL ?>";
    </script>

    <!-- Page spacing for fixed navbar -->
    <main>