<?php
// Defaults
$userPermissions = [];
$userRole = null;
$row=[];
if (!empty($_SESSION['user_uid'])) {

    include_once __DIR__ . "/../../config/dbcon.php";

    $stmt = $conn->prepare("
        SELECT role, status, user_permissions
        FROM users
        WHERE firebase_uid = :uid
        LIMIT 1
    ");
    $stmt->execute([':uid' => $_SESSION['user_uid']]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {

        $userRole = $row['role'];

        if ($userRole === 'superadmin') {
        
            $userPermissions = []; 
        }

        if ($userRole === 'subadmin' && $row['status'] === 'accept') {

            if (!empty($row['user_permissions'])) {
                $decoded = json_decode($row['user_permissions'], true);

                if (is_array($decoded)) {
                    $userPermissions = $decoded;
                }
            }
        }
    }
}

$isSuperAdmin = ($userRole === 'superadmin');

?>


<button class="mobile-menu-btn" onclick="openMobileSidebar()">
    <i class="fas fa-bars"></i>
</button>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <!-- Desktop Toggle Button -->
    <div class="toggle-btn" onclick="toggleSidebar()" title="Toggle Sidebar">
        <i class="fas fa-bars"></i>
    </div>

    <!-- Mobile Close Button (Shows only on mobile) -->
    <button class="mobile-close-btn" onclick="closeMobileSidebar()" title="Close Menu">
        <i class="fas fa-times"></i>
    </button>

    <!-- Logo -->
    <div class="logo">JobAdmin</div>

    <!-- Navigation Links -->
    <ul class="list-unstyled">

        <!-- GENERAL -->
        <li class="menu-heading px-3 pt-3 pb-1 text-uppercase fw-semibold text-primary" style="font-size: 0.9rem;">
      General
        </li>
        <li>
            <a href="/carrier_job_admin/view/backend/dashboard.php" class="
                <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : '' ?>">
                <i class="icon fas fa-chart-line text-primary"></i>
                <span class="text">Dashboard</span>
            </a>
        </li>

        <!-- LOCATION MANAGEMENT -->
        <?php if (
            $isSuperAdmin ||
            in_array('manage_country', $userPermissions) ||
            in_array('manage_state', $userPermissions) ||
            in_array('manage_city', $userPermissions)
        ): ?>
            <li class="menu-heading px-3 pt-3 pb-1 mt-2 text-uppercase small fw-semibold text-success"
                style="font-size: 0.9rem;">
                Location Management
            </li>

            <?php if ($isSuperAdmin || in_array('manage_country', $userPermissions)): ?>
                <li>
                    <a href="/carrier_job_admin/view/backend/country/country_list.php"
                        class="<?= basename($_SERVER['PHP_SELF']) == 'country_list.php' ? 'active' : '' ?>">
                        <i class="icon fas fa-globe text-success"></i>
                        <span class="text">Country</span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if ($isSuperAdmin || in_array('manage_state', $userPermissions)): ?>
                <li>
                    <a href="/carrier_job_admin/view/backend/state/state_list.php"
                        class="<?= basename($_SERVER['PHP_SELF']) == 'state_list.php' ? 'active' : '' ?>">
                        <i class="icon fas fa-map text-success"></i>
                        <span class="text">State</span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if ($isSuperAdmin || in_array('manage_city', $userPermissions)): ?>
                <li>
                    <a href="/carrier_job_admin/view/backend/city/city_list.php"
                        class="<?= basename($_SERVER['PHP_SELF']) == 'city_list.php' ? 'active' : '' ?>">
                        <i class="icon fas fa-city text-success"></i>
                        <span class="text">City</span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <!-- CONTENT MANAGEMENT -->
        <?php if (
            $isSuperAdmin ||
            in_array('manage_category', $userPermissions) ||
            in_array('manage_job', $userPermissions)
        ): ?>
            <li class="menu-heading px-3 pt-3 pb-1 mt-2 text-uppercase small fw-semibold text-warning"
                style="font-size: 0.9rem;">
                Content Management
            </li>

            <?php if ($isSuperAdmin || in_array('manage_category', $userPermissions)): ?>
                <li>
                    <a href="/carrier_job_admin/view/backend/category/category_list.php"
                        class="<?= basename($_SERVER['PHP_SELF']) == 'category_list.php' ? 'active' : '' ?>">
                        <i class="icon fas fa-th-large text-warning"></i>
                        <span class="text">Category</span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if ($isSuperAdmin || in_array('manage_job', $userPermissions)): ?>
                <li>
                    <a href="/carrier_job_admin/view/backend/job/job_list.php"
                        class="<?= basename($_SERVER['PHP_SELF']) == 'job_list.php' ? 'active' : '' ?>">
                        <i class="icon fas fa-briefcase text-warning"></i>
                        <span class="text">Jobs</span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <?php if ($isSuperAdmin || in_array('manage_user', $userPermissions)): ?>
            <!-- USER & ACCESS -->
            <li class="menu-heading px-3 pt-3 pb-1 mt-2 text-uppercase small fw-semibold text-danger"
                style="font-size: 0.9rem;">
                User & Access
            </li>

            <li>
                <a href="/carrier_job_admin/view/backend/user/user_list.php"
                    class="<?= basename($_SERVER['PHP_SELF']) == 'user_list.php' ? 'active' : '' ?>">
                    <i class="icon fas fa-user text-danger"></i>
                    <span class="text">User</span>
                </a>
            </li>
        <?php endif; ?>

        <?php if ($isSuperAdmin): ?>
            <li>
                <a href="/carrier_job_admin/view/backend/request/request.php"
                    class="<?= basename($_SERVER['PHP_SELF']) == 'request.php' ? 'active' : '' ?>">
                    <i class="icon fas fa-user-shield text-danger"></i>
                    <span class="text">Manage Permission</span>
                </a>
            </li>
        <?php endif; ?>

        <?php if ($isSuperAdmin || in_array('manage_policies', $userPermissions)): ?>
            <!-- Policy -->
            <li class="menu-heading px-3 pt-3 pb-1 mt-2 text-uppercase small fw-semibold text-info"
                style="font-size: 0.9rem;">
                Policy Management
            </li>


            <li>
                <a href="/carrier_job_admin/view/backend/page/page_list.php"
                    class="<?= basename($_SERVER['PHP_SELF']) == 'page_list.php' ? 'active' : '' ?>">
                    <i class="icon fas fa-file-contract text-info"></i>
                    <span class="text">Page</span>
                </a>
            </li>
        <?php endif; ?>

    </ul>


</div>

<!-- Mobile Overlay -->
<div class="sidebar-overlay" id="sidebarOverlay" onclick="closeMobileSidebar()"></div>