<?php
try {

    header("Content-Type: application/json");
    include_once dirname(__DIR__, 2) . "/config/dbcon.php";
    include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
    }

    $input = json_decode(file_get_contents("php://input"), true);


    $id = $input['id'] ?? null;
    if (empty($id)) {
        sendResponse(400, "Page id is required");
    }


    $stmt = $conn->prepare("
        SELECT id 
        FROM pages 
        WHERE id = ? AND deleted_at IS NULL
    ");
    $stmt->execute([$id]);
    $job = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$job) {
        sendResponse(404, "Page not found or already deleted");
    }


    $stmt = $conn->prepare("
        UPDATE pages SET
            deleted_at = NOW(),
            updated_at = NOW()
        WHERE id = ?
    ");
    $stmt->execute([$id]);

    sendResponse(200, "Page deleted successfully");

} catch (PDOException $e) {
    sendResponse(500, "Server Error");
}
?>