<?php
header('Content-Type: application/json');
session_start();

include_once __DIR__ . '/../../config/dbcon.php'; // PDO connection
include_once __DIR__ . '/../../helpers/api_helper.php';

try {
    $stmt = $conn->prepare("
        SELECT 
            type,
            description
        FROM pages
        WHERE type IN ('privacy_policy', 'terms_conditions')
        AND deleted_at IS NULL
    ");

    $stmt->execute();
    $policies = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $data = [
        'privacy_policy' => null,
        'terms_conditions' => null
    ];

    foreach ($policies as $policy) {
        if ($policy['type'] === 'privacy_policy') {
            $data['privacy_policy'] = $policy['description'];
        }

        if ($policy['type'] === 'terms_conditions') {
            $data['terms_conditions'] = $policy['description'];
        }
    }

    sendResponse(200, "Policies fetched successfully.", $data);

} catch (PDOException $e) {
    sendResponse(500, "Database error: " . $e->getMessage());
}
