<?php

include_once dirname(__DIR__, 2) . "/helpers/api_helper.php";
include_once dirname(__DIR__, 2) . "/firebase/firebase_init.php";

try {

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        sendResponse(405, "Method Not Allowed");
    }

    $input = json_decode(file_get_contents("php://input"), true);

    $uid = $input['uid'] ?? null; // Firebase UID
    $newPassword = $input['new_password'] ?? null;
    $confirmPassword = $input['confirm_password'] ?? null;

    if (empty($uid)) {
        sendResponse(400, "User UID is required");
    }

    if (empty($newPassword)) {
        sendResponse(400, "New password is required");
    }

    if (strlen($newPassword) < 6) {
        sendResponse(400, "Password must be at least 6 characters");
    }

    if ($newPassword !== $confirmPassword) {
        sendResponse(400, "Passwords do not match");
    }

    $auth->changeUserPassword($uid, $newPassword);

    sendResponse(200, "Password changed successfully");

} catch (\Kreait\Firebase\Exception\Auth\UserNotFound $e) {

    sendResponse(404, "User not found");

} catch (Exception $e) {

    sendResponse(500, $e->getMessage());
}
